# Classe servant  grer les objets virtuels
# 
# v1.0

begin
  require "Base64"
rescue LoadError
  
end

class Virtual_Object


  attr_accessor :name
  attr_accessor :contenu
  attr_accessor :parent



  @@absorb = true

  def initialize(name, parent=nil, contenu=nil)
    @name = name
    @parent = parent
    parent.add_child(self) if parent != nil
    @contenu = contenu
    
  end


  def add_child(child)
    @children << child
  end


  # Renvoie le chemin absolu d'un lment
  def path(range=nil)
    if @parent.is_a?(Virtual_Object)
      pat = File.join(@parent.path, @name)
      # On regarde s'il y a un range dlimitant la partie du path
      #  rcuprer
      if range != nil
        dirs = pat.split("/")
        if range.end == -1
          return File.join(*dirs[range.begin...dirs.size])
        else
          return File.join(*dirs[range.begin...range.end])
        end
      end
      return pat
    else
      return @name if @parent == nil
      return @name
    end
  end

  # Renvoie une arborescence plus courte
  def shorten
    get = 0
    while true
      if self.children.size == 0
        return self
      end
      if self.children.size == 1
        if self.children[0].is_a?(Virtual_Dir)
          return self.children[0].shorten
        else
          return self
        end
      end
      if self.children.size > 1
        return self
      end
    end

  end

  
  # Permet de crer un objet virtuel sans risquer de confondre
  # un dossier avec un fichier ou inversement
  def self.dir_or_file(name, dir)
    if File.directory?(name)
      return Virtual_Dir.new(name, dir)
    else
      return Virtual_File.new(name, dir)
    end
  end
  
  def inspect2
    return "#<#{self.class}: @name=\"#{@name}\", @dir=#{@dir == nil ? "nil" : (@dir.respond_to?(:inspect2) ? @dir.inspect2 : @dir)}>"
  end

  
  def self.absorb=(value)
    @@absorb = value
  end


  def self.inspect_list(list)
    txt = ""
    for file in list

      if file.is_a?(Virtual_Dir)
        type = "dir"
        contenu = file.contenu.size
      else
        type = "file"
        if file.contenu != nil
          contenu = file.contenu.size.to_s+"o"
        else
          contenu = "#"
        end
      end

      line = "#{file.name.ljust(10)} #{type.ljust(4)} #{contenu.rjust(8)}"
      txt << line << "\n"
    end
    return txt
  end


  def ancestors
    
    if @parent != nil
      #p self.name
      list = @parent.ancestors
      list << self
      return list
    end
    return [self]
  end
end